/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.inferencing;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.parsing.ast.JSNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPropertyCollection {
    private List<JSNode> values;
    private List<String> types;
    private Map<String, JSPropertyCollection> properties;
    private String name;
    private JSPropertyCollection parentProperty;
    private PropertyElement _element;

    public void addType(String type) {
        if (this.types == null) {
            this.types = new ArrayList<String>();
        }
        if (type != null && type.length() > 0 && !this.types.contains(type)) {
            this.types.add(type);
        }
    }

    public void addValue(JSNode value) {
        if (value != null) {
            if (this.values == null) {
                this.values = new ArrayList<JSNode>();
            }
            this.values.add(value);
        }
    }

    public void clearTypes() {
        this.types = null;
    }

    public String getQualifiedName() {
        ArrayList<String> parts = new ArrayList<String>();
        JSPropertyCollection current = this;
        while (current != null) {
            String name = current.getName();
            if (StringUtil.isEmpty((String)name)) break;
            parts.add(name);
            current = current.getParentProperty();
        }
        Collections.reverse(parts);
        return StringUtil.join((String)".", parts);
    }

    public String getName() {
        return this.name;
    }

    public JSPropertyCollection getParentProperty() {
        return this.parentProperty;
    }

    public JSPropertyCollection getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    public List<String> getPropertyNames() {
        List<String> result = this.properties != null ? new ArrayList<String>(this.properties.keySet()) : Collections.emptyList();
        return result;
    }

    public List<String> getTypes() {
        return CollectionsUtil.getListValue(this.types);
    }

    public List<JSNode> getValues() {
        return CollectionsUtil.getListValue(this.values);
    }

    public boolean hasProperties() {
        return !CollectionsUtil.isEmpty(this.properties);
    }

    public boolean hasProperty(String name) {
        boolean result = false;
        if (this.properties != null) {
            result = this.properties.containsKey(name);
        }
        return result;
    }

    public boolean hasTypes() {
        return this.types != null;
    }

    public void setProperty(String name, JSPropertyCollection property) {
        if (name != null && name.length() > 0 && property != null) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, JSPropertyCollection>();
            }
            this.properties.put(name, property);
            property.name = name;
            property.parentProperty = this;
        }
    }

    public String toSource() {
        SourcePrinter printer = new SourcePrinter();
        this.toSource(printer);
        return printer.toString();
    }

    protected void toSource(SourcePrinter printer) {
        if (this.properties != null) {
            for (Map.Entry<String, JSPropertyCollection> entry : this.properties.entrySet()) {
                String name = entry.getKey();
                JSPropertyCollection object = entry.getValue();
                printer.printIndent().print(name);
                if (object.values != null) {
                    printer.print(object.values);
                } else {
                    printer.print("[]");
                }
                if (object.hasProperties()) {
                    printer.println(" {").increaseIndent();
                    entry.getValue().toSource(printer);
                    printer.decreaseIndent().printlnWithIndent("}");
                    continue;
                }
                printer.println();
            }
        }
    }

    public void setElement(PropertyElement result) {
        this._element = result;
    }

    public boolean hasElement() {
        return this._element != null;
    }

    public PropertyElement getElement() {
        return this._element;
    }
}

